#include <iostream>
#include <vector>

using namespace std;

#define ogranicenje 31

int broj_bitova(int broj) {
    int brojBitova = 0;
    while(broj) {
        brojBitova++;
        broj >>= 1;
    }
    return brojBitova;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    int n, q;
    cin >> n >> q;
    
    vector<vector<int> > prefiksneSume(ogranicenje, vector<int>(n+1));
    for(int bit = 0; bit < ogranicenje; bit++)
        prefiksneSume[bit][0] = 0;
    
    for(int i = 1; i <= n; i++) {
        int broj;
        cin >> broj;
        
        for(int bit = 0; bit < ogranicenje; bit++)
            prefiksneSume[bit][i] = prefiksneSume[bit][i-1];
        
        int brojBitova = broj_bitova(broj);
        prefiksneSume[brojBitova][i]++;
    }
    
    while(q--) {
        int l, r;
        cin >> l >> r;
        
        int najduziDobarPodniz = 0;
        for(int bit = 0; bit < ogranicenje; bit++)
            najduziDobarPodniz = max(najduziDobarPodniz, prefiksneSume[bit][r] - prefiksneSume[bit][l-1]);
        
        cout << najduziDobarPodniz << '\n';
    }
    
    return 0;
}